/*
 * Decompiled with CFR 0.152.
 */
package entities;

import core.Sprite;
import java.awt.Rectangle;
import util.ResourceManager;

public abstract class Entity {
    protected Sprite sprite;
    protected double x;
    protected double y;
    protected double dx;
    protected double dy;
    protected Rectangle hitbox;

    public Entity(String ref, int x, int y) {
        if (ref != null) {
            this.sprite = ResourceManager.get().getSprite(ref);
        }
        this.x = x;
        this.y = y;
        this.dy = 0.0;
        this.dx = 0.0;
        this.hitbox = new Rectangle();
    }

    public void setSprite(String ref) {
        this.sprite = ResourceManager.get().getSprite(ref);
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void move(long delta) {
        this.x += (double)delta * this.dx / 1000.0;
        this.y += (double)delta * this.dy / 1000.0;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void draw() {
        this.sprite.draw((int)this.x, (int)this.y);
    }

    public void doLogic() {
        this.calculateHitbox();
    }

    protected void calculateHitbox() {
        this.hitbox.setBounds((int)this.x, (int)this.y, this.getW(), this.getH());
    }

    public Rectangle getHitbox() {
        return this.hitbox;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public int getW() {
        return this.getSprite().getWidth();
    }

    public int getH() {
        return this.getSprite().getHeight();
    }

    public boolean collidesWith(Entity other) {
        return this.hitbox.intersects(other.getHitbox());
    }

    public abstract void collidedWith(Entity var1);
}

